/*
 * Decompiled with CFR 0.152.
 */
package osrs;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.imageio.ImageIO;
import osrs.RGBColor;
import osrs.RSSpritePixels;

public final class NRSettings {
    public static final boolean enableCs2DebugPrints = false;
    public static final HashMap<Integer, RSSpritePixels> imageSpriteOverrides = new HashMap();
    private static final RGBColor DEFAULT_TRANS = new RGBColor(255, 0, 255);

    private NRSettings() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static void loadCustomItemSprites() {
        try {
            NRSettings.loadAllFromResource();
            System.out.println("Loaded custom item sprites (total: " + imageSpriteOverrides.size() + ")");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void loadAllFromResource() throws IOException, URISyntaxException {
        String resourceFolder = "custom_sprites";
        URL url = NRSettings.class.getResource(resourceFolder);
        if (url == null) {
            throw new IllegalStateException("Resource folder not found: " + resourceFolder);
        }
        if (url.getProtocol().equals("file")) {
            Path folder = Paths.get(url.toURI());
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(folder, "*.png");){
                for (Path png : ds) {
                    int id = Integer.parseInt(png.getFileName().toString().replaceFirst("\\.png$", ""));
                    imageSpriteOverrides.put(id, NRSettings.loadSpritePixels(NRSettings.class.getResourceAsStream(resourceFolder + "/" + String.valueOf(png.getFileName()))));
                }
            }
        }
        if (url.getProtocol().equals("jar")) {
            String path = url.getPath();
            String jarPath = path.substring(5, path.indexOf("!"));
            try (JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));){
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith(resourceFolder + "/") || !name.endsWith(".png")) continue;
                    String fileName = name.substring(name.lastIndexOf(47) + 1);
                    int id = Integer.parseInt(fileName.replaceFirst("\\.png$", ""));
                    InputStream is = NRSettings.class.getResourceAsStream(name);
                    try {
                        imageSpriteOverrides.put(id, NRSettings.loadSpritePixels(is));
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
            }
        }
        throw new UnsupportedOperationException("Unsupported protocol: " + url.getProtocol());
    }

    private static RSSpritePixels loadSpritePixels(InputStream pngFile) throws IOException {
        BufferedImage img = ImageIO.read(pngFile);
        int w = img.getWidth();
        int h = img.getHeight();
        RSSpritePixels sp = new RSSpritePixels(w, h);
        img.getRGB(0, 0, w, h, sp.pixels, 0, w);
        NRSettings.applyTransparency(sp.pixels);
        return sp;
    }

    public static void applyTransparency(int[] pixels) {
        RGBColor transparency = DEFAULT_TRANS;
        for (int i = 0; i < pixels.length; ++i) {
            int pixel = pixels[i];
            int alpha = pixel >> 24 & 0xFF;
            int red = pixel >> 16 & 0xFF;
            int green = pixel >> 8 & 0xFF;
            int blue = pixel & 0xFF;
            if (alpha != 0 && (red != transparency.getRed() || green != transparency.getGreen() || blue != transparency.getBlue())) continue;
            pixels[i] = 0;
        }
    }
}

