/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class IMGGenerateMipmap {
    public static final int CL_MIPMAP_FILTER_ANY_IMG = 0;
    public static final int CL_MIPMAP_FILTER_BOX_IMG = 1;
    public static final int CL_COMMAND_GENERATE_MIPMAP_IMG = 16598;

    protected IMGGenerateMipmap() {
        throw new UnsupportedOperationException();
    }

    public static int nclEnqueueGenerateMipmapIMG(long command_queue, long src_image, long dst_image, int mipmap_filter_mode, long array_region, long mip_region, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueGenerateMipmapIMG;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
            Checks.check(src_image);
            Checks.check(dst_image);
        }
        return JNI.callPPPPPPPI(command_queue, src_image, dst_image, mipmap_filter_mode, array_region, mip_region, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueGenerateMipmapIMG(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_image, @NativeType(value="cl_mem") long dst_image, @NativeType(value="cl_mipmap_filter_mode_img") int mipmap_filter_mode, @NativeType(value="size_t const *") @Nullable PointerBuffer array_region, @NativeType(value="size_t const *") @Nullable PointerBuffer mip_region, @NativeType(value="cl_event const *") @Nullable PointerBuffer event_wait_list, @NativeType(value="cl_event *") @Nullable PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(array_region, 2);
            Checks.checkSafe(mip_region, 2);
            Checks.checkSafe(event, 1);
        }
        return IMGGenerateMipmap.nclEnqueueGenerateMipmapIMG(command_queue, src_image, dst_image, mipmap_filter_mode, MemoryUtil.memAddressSafe(array_region), MemoryUtil.memAddressSafe(mip_region), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }
}

