/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsHandshakeHash;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class SSL3Utils {
    private static final byte[] SSL_CLIENT = new byte[]{67, 76, 78, 84};
    private static final byte[] SSL_SERVER = new byte[]{83, 82, 86, 82};
    private static final byte IPAD_BYTE = 54;
    private static final byte OPAD_BYTE = 92;
    private static final byte[] IPAD = SSL3Utils.genPad((byte)54, 48);
    private static final byte[] OPAD = SSL3Utils.genPad((byte)92, 48);

    SSL3Utils() {
    }

    static byte[] calculateVerifyData(TlsHandshakeHash tlsHandshakeHash, boolean bl) {
        TlsHash tlsHash = tlsHandshakeHash.forkPRFHash();
        byte[] byArray = bl ? SSL_SERVER : SSL_CLIENT;
        tlsHash.update(byArray, 0, byArray.length);
        return tlsHash.calculateHash();
    }

    static void completeCombinedHash(TlsContext tlsContext, TlsHash tlsHash, TlsHash tlsHash2) {
        TlsSecret tlsSecret = tlsContext.getSecurityParametersHandshake().getMasterSecret();
        byte[] byArray = tlsContext.getCrypto().adoptSecret(tlsSecret).extract();
        SSL3Utils.completeHash(byArray, tlsHash, 48);
        SSL3Utils.completeHash(byArray, tlsHash2, 40);
    }

    private static void completeHash(byte[] byArray, TlsHash tlsHash, int n) {
        tlsHash.update(byArray, 0, byArray.length);
        tlsHash.update(IPAD, 0, n);
        byte[] byArray2 = tlsHash.calculateHash();
        tlsHash.update(byArray, 0, byArray.length);
        tlsHash.update(OPAD, 0, n);
        tlsHash.update(byArray2, 0, byArray2.length);
    }

    private static byte[] genPad(byte by, int n) {
        byte[] byArray = new byte[n];
        Arrays.fill(byArray, by);
        return byArray;
    }

    static byte[] readEncryptedPMS(InputStream inputStream) throws IOException {
        return Streams.readAll(inputStream);
    }

    static void writeEncryptedPMS(byte[] byArray, OutputStream outputStream) throws IOException {
        outputStream.write(byArray);
    }
}

