/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ping;

import com.google.common.primitives.Bytes;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.runelite.client.ping.IPHlpAPI;
import net.runelite.client.ping.IcmpEchoReply;
import net.runelite.client.ping.IcmpV6EchoReply;
import net.runelite.client.ping.RLLibC;
import net.runelite.client.ping.SOCKADDR_IN6_LH;
import net.runelite.client.ping.Timeval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Ping {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Ping.class);
    public static final long INVALID_PING_RETURN_VALUE = -1L;
    private static final byte[] RUNELITE_PING = "RuneLitePing".getBytes(StandardCharsets.UTF_8);
    private static final int TIMEOUT_MS = 2000;
    private static final long TIMEOUT_S = TimeUnit.MILLISECONDS.toSeconds(2000L);
    private static final long TIMEOUT_NS = TimeUnit.MILLISECONDS.toNanos(2000L);
    private static final int MAX_IPV4_HEADER_SIZE = 60;
    private static final int ICMPV6_ECHO_REQUEST_TYPE = 128;
    private static final int ICMPV6_ECHO_REPLY_TYPE = 129;
    private static final int IPPROTO_ICMPV6 = 58;
    private static short seq;

    /*
     * Exception decompiling
     */
    public static long ping(String host, int port) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static long windowsPing(InetAddress inetAddress) {
        if (inetAddress instanceof Inet4Address) {
            return Ping.windowsPingV4(inetAddress);
        }
        if (inetAddress instanceof Inet6Address) {
            return Ping.windowsPingV6((Inet6Address)inetAddress);
        }
        log.warn("Ping is not supported for this address type: {}", (Object)inetAddress.getClass().getName());
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long windowsPingV4(InetAddress inetAddress) {
        IPHlpAPI ipHlpAPI = IPHlpAPI.INSTANCE;
        Pointer ptr = ipHlpAPI.IcmpCreateFile();
        try {
            byte[] address = inetAddress.getAddress();
            byte[] runelitePing = RUNELITE_PING;
            int runelitePingLength = runelitePing.length;
            Memory data = new Memory(runelitePingLength);
            data.write(0L, runelitePing, 0, runelitePingLength);
            long replyPointerSize = IcmpEchoReply.SIZE + runelitePingLength;
            Memory replyPointer = new Memory(replyPointerSize);
            IcmpEchoReply reply = new IcmpEchoReply(replyPointer);
            int packed = address[0] & 0xFF | (address[1] & 0xFF) << 8 | (address[2] & 0xFF) << 16 | (address[3] & 0xFF) << 24;
            int ret = ipHlpAPI.IcmpSendEcho(ptr, packed, data, (short)runelitePingLength, Pointer.NULL, reply, (int)replyPointerSize, 2000);
            if (ret != 1) {
                long l = -1L;
                return l;
            }
            long l = TimeUnit.MILLISECONDS.toNanos(reply.roundTripTime.longValue());
            return l;
        }
        finally {
            ipHlpAPI.IcmpCloseHandle(ptr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long windowsPingV6(Inet6Address inetAddress) {
        IPHlpAPI ipHlpAPI = IPHlpAPI.INSTANCE;
        Pointer ptr = ipHlpAPI.Icmp6CreateFile();
        try {
            byte[] address = inetAddress.getAddress();
            byte[] runelitePing = RUNELITE_PING;
            int runelitePingLength = runelitePing.length;
            Memory data = new Memory(runelitePingLength);
            data.write(0L, runelitePing, 0, runelitePingLength);
            long replyPointerSize = 24 + runelitePingLength;
            Memory replyPointer = new Memory(replyPointerSize);
            IcmpV6EchoReply reply = new IcmpV6EchoReply(replyPointer);
            SOCKADDR_IN6_LH.ByValue dest = new SOCKADDR_IN6_LH.ByValue();
            dest.sin6_family = (short)23;
            dest.sin6_addr = address;
            dest.sin6_scope_id = inetAddress.getScopeId();
            int ret = ipHlpAPI.Icmp6SendEcho2(ptr, null, null, null, dest, data, (short)runelitePingLength, null, reply, (int)replyPointerSize, 2000);
            if (ret != 1) {
                long l = -1L;
                return l;
            }
            long l = TimeUnit.MILLISECONDS.toNanos(reply.roundTripTime);
            return l;
        }
        finally {
            ipHlpAPI.IcmpCloseHandle(ptr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long icmpPing(InetAddress inetAddress, boolean includeIpHeader) throws IOException {
        int proto;
        byte[] address = inetAddress.getAddress();
        RLLibC libc = RLLibC.INSTANCE;
        boolean isIPv6 = inetAddress instanceof Inet6Address;
        int af = isIPv6 ? RLLibC.AF_INET6 : 2;
        int sock = libc.socket(af, 2, proto = isIPv6 ? 58 : 1);
        if (sock < 0) {
            throw new IOException("failed to open ICMP socket, error: " + Native.getLastError());
        }
        try {
            block17: {
                long end;
                byte[] addr;
                byte[] request;
                Timeval tv = new Timeval();
                tv.tv_sec = TIMEOUT_S;
                tv.write();
                if (libc.setsockopt(sock, RLLibC.SOL_SOCKET, RLLibC.SO_RCVTIMEO, tv.getPointer(), tv.size()) < 0) {
                    throw new IOException("failed to set SO_RCVTIMEO");
                }
                if (libc.setsockopt(sock, RLLibC.SOL_SOCKET, RLLibC.SO_SNDTIMEO, tv.getPointer(), tv.size()) < 0) {
                    throw new IOException("failed to set SO_SNDTIMEO");
                }
                short s = seq;
                seq = (short)(s + 1);
                short seqno = s;
                if (isIPv6) {
                    request = new byte[]{-128, 0, 0, 0, 0, 0, (byte)(seqno >> 8), (byte)seqno};
                    request = Bytes.concat(request, RUNELITE_PING);
                    byte[] srcAddr = new byte[16];
                    short checksum = Ping.checksum6(srcAddr, address, request);
                    request[2] = (byte)(checksum >> 8);
                    request[3] = (byte)checksum;
                    SOCKADDR_IN6_LH sockaddr = new SOCKADDR_IN6_LH();
                    sockaddr.sin6_family = (short)af;
                    sockaddr.sin6_addr = address;
                    sockaddr.sin6_scope_id = ((Inet6Address)inetAddress).getScopeId();
                    sockaddr.write();
                    addr = sockaddr.getPointer().getByteArray(0L, sockaddr.size());
                } else {
                    request = new byte[]{8, 0, 0, 0, 0, 0, (byte)(seqno >> 8 & 0xFF), (byte)(seqno & 0xFF)};
                    request = Bytes.concat(request, RUNELITE_PING);
                    short checksum = Ping.checksum(request);
                    request[2] = (byte)(checksum >> 8 & 0xFF);
                    request[3] = (byte)(checksum & 0xFF);
                    addr = new byte[]{2, 0, 0, 0, address[0], address[1], address[2], address[3], 0, 0, 0, 0, 0, 0, 0, 0};
                }
                int responseSize = isIPv6 ? 8 + RUNELITE_PING.length : 8 + RUNELITE_PING.length + (includeIpHeader ? 60 : 0);
                Memory response = new Memory(responseSize);
                int requestLength = request.length;
                long start = System.nanoTime();
                if (libc.sendto(sock, request, requestLength, 0, addr, addr.length) != requestLength) {
                    long l = -1L;
                    return l;
                }
                while (true) {
                    byte expectedReplyType;
                    if (System.nanoTime() - start > TIMEOUT_NS) {
                        log.warn("timeout elapsed checking for echo reply");
                        break block17;
                    }
                    int rlen = libc.recvfrom(sock, response, responseSize, 0, null, null);
                    end = System.nanoTime();
                    if (rlen <= 0) {
                        log.warn("recvfrom() error: len {} errno {}", (Object)rlen, (Object)Native.getLastError());
                        break block17;
                    }
                    int icmpHeaderOffset = 0;
                    if (includeIpHeader && !isIPv6) {
                        int ihl = response.getByte(0L) & 0xF;
                        icmpHeaderOffset = ihl << 2;
                    }
                    if (icmpHeaderOffset + 7 >= rlen) {
                        log.warn("packet too short (received {} bytes but icmp header offset is {})", (Object)rlen, (Object)icmpHeaderOffset);
                        continue;
                    }
                    byte replyType = response.getByte(icmpHeaderOffset);
                    byte by = expectedReplyType = isIPv6 ? (byte)-127 : 0;
                    if (replyType != expectedReplyType) {
                        log.warn("non-echo reply mismatch ({} != {})", (Object)replyType, (Object)expectedReplyType);
                        continue;
                    }
                    short seq = (short)((response.getByte(icmpHeaderOffset + 6) & 0xFF) << 8 | response.getByte(icmpHeaderOffset + 7) & 0xFF);
                    if (seqno == seq) break;
                    log.warn("sequence number mismatch ({} != {})", (Object)seqno, (Object)seq);
                }
                long l = end - start;
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            libc.close(sock);
        }
    }

    private static short checksum(byte[] data) {
        int sum = 0;
        for (int i = 0; i < data.length - 1; i += 2) {
            sum += (data[i] & 0xFF) << 8 | data[i + 1] & 0xFF;
        }
        if ((data.length & 1) != 0) {
            sum += (data[data.length - 1] & 0xFF) << 8;
        }
        sum = (sum >> 16 & 0xFFFF) + (sum & 0xFFFF);
        return (short)(~sum & 0xFFFF);
    }

    private static short checksum6(byte[] srcAddr, byte[] dstAddr, byte[] icmpPacket) {
        ByteBuffer bb = ByteBuffer.allocate(40 + icmpPacket.length);
        bb.put(srcAddr);
        bb.put(dstAddr);
        bb.putInt(icmpPacket.length);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)58);
        bb.put(icmpPacket);
        return Ping.checksum(bb.array());
    }

    private static long tcpPing(InetAddress inetAddress, int port) throws IOException {
        try (Socket socket = new Socket();){
            socket.setSoTimeout(2000);
            socket.setTcpNoDelay(true);
            InetSocketAddress address = new InetSocketAddress(inetAddress, port);
            long start = System.nanoTime();
            socket.connect(address);
            long end = System.nanoTime();
            long l = end - start;
            return l;
        }
    }
}

