/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.chat;

import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Singleton;
import lombok.Generated;
import net.runelite.api.Client;
import net.runelite.api.events.CommandExecuted;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ChatboxInput;
import net.runelite.client.events.PrivateMessageInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class ChatInputManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChatInputManager.class);
    private static final String RUNELITE_COMMAND = "runeliteCommand";
    private static final String CHATBOX_INPUT = "chatboxInput";
    private static final String PRIVATE_MESSAGE = "privateMessage";
    private final Client client;
    private final EventBus eventBus;
    private final ClientThread clientThread;
    private boolean sending;

    @Inject
    ChatInputManager(Client client2, EventBus eventBus, ClientThread clientThread) {
        this.client = client2;
        this.eventBus = eventBus;
        this.clientThread = clientThread;
        eventBus.register(this);
    }

    @Subscribe
    private void onScriptCallbackEvent(ScriptCallbackEvent event) {
        if (this.sending) {
            return;
        }
        switch (event.getEventName()) {
            case "runeliteCommand": {
                this.runCommand();
                break;
            }
            case "chatboxInput": {
                this.handleInput(event);
                break;
            }
            case "privateMessage": {
                this.handlePrivateMessage(event);
            }
        }
    }

    private void runCommand() {
        String typedText = this.client.getVarcStrValue(335).substring(2);
        log.debug("Command: {}", (Object)typedText);
        String[] split = typedText.split(" ");
        if (split.length == 0) {
            return;
        }
        String command = split[0];
        String[] args = Arrays.copyOfRange(split, 1, split.length);
        CommandExecuted commandExecuted = new CommandExecuted(command, args);
        this.eventBus.post(commandExecuted);
    }

    private void handleInput(ScriptCallbackEvent event) {
        String[] stringStack = this.client.getStringStack();
        int[] intStack = this.client.getIntStack();
        int stringStackCount = this.client.getStringStackSize();
        int intStackCount = this.client.getIntStackSize();
        String typedText = stringStack[stringStackCount - 1];
        int chatType = intStack[intStackCount - 2];
        int clanTarget = intStack[intStackCount - 1];
        ChatboxInput chatboxInput = new ChatboxInput(typedText, chatType, () -> this.clientThread.invokeLater(() -> this.sendChatboxInput(typedText, chatType, clanTarget)));
        this.eventBus.post(chatboxInput);
        if (chatboxInput.isConsumed()) {
            stringStack[stringStackCount - 1] = "";
        }
    }

    private void handlePrivateMessage(ScriptCallbackEvent event) {
        String[] stringStack = this.client.getStringStack();
        int[] intStack = this.client.getIntStack();
        int stringStackCount = this.client.getStringStackSize();
        int intStackCount = this.client.getIntStackSize();
        String target = stringStack[stringStackCount - 2];
        String message = stringStack[stringStackCount - 1];
        PrivateMessageInput privateMessageInput = new PrivateMessageInput(target, message, () -> this.clientThread.invokeLater(() -> this.sendPrivmsg(target, message)));
        this.eventBus.post(privateMessageInput);
        if (privateMessageInput.isConsumed()) {
            intStack[intStackCount - 1] = 1;
            this.client.setStringStackSize(stringStackCount - 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendChatboxInput(String input, int chatType, int clanTarget) {
        this.sending = true;
        try {
            this.client.runScript(5517, input, chatType, clanTarget, 0, -1);
        }
        finally {
            this.sending = false;
        }
    }

    private void sendPrivmsg(String target, String message) {
        this.client.runScript(10004, target, message);
    }
}

