/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto;

import java.io.IOException;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TlsHybridAgreement
implements TlsAgreement {
    private final TlsCrypto crypto;
    private final TlsAgreement firstAgreement;
    private final TlsAgreement secondAgreement;
    private final int peerValueSplit;

    public TlsHybridAgreement(TlsCrypto tlsCrypto, TlsAgreement tlsAgreement, TlsAgreement tlsAgreement2, int n) {
        this.crypto = tlsCrypto;
        this.firstAgreement = tlsAgreement;
        this.secondAgreement = tlsAgreement2;
        this.peerValueSplit = n;
    }

    @Override
    public byte[] generateEphemeral() throws IOException {
        byte[] byArray = this.firstAgreement.generateEphemeral();
        byte[] byArray2 = this.secondAgreement.generateEphemeral();
        return Arrays.concatenate(byArray, byArray2);
    }

    @Override
    public void receivePeerValue(byte[] byArray) throws IOException {
        if (byArray.length < this.peerValueSplit) {
            throw new IllegalArgumentException("'peerValue' is too short");
        }
        this.firstAgreement.receivePeerValue(Arrays.copyOfRange(byArray, 0, this.peerValueSplit));
        this.secondAgreement.receivePeerValue(Arrays.copyOfRange(byArray, this.peerValueSplit, byArray.length));
    }

    @Override
    public TlsSecret calculateSecret() throws IOException {
        TlsSecret tlsSecret = this.firstAgreement.calculateSecret();
        TlsSecret tlsSecret2 = this.secondAgreement.calculateSecret();
        return this.crypto.createHybridSecret(tlsSecret, tlsSecret2);
    }
}

